/**
 * Created by lei.wang_1 on 2016/12/8.
 */
appModule.directive("userList",["utils","notices",function(utils,notices){
    return{
        template:`<div class="limit">
                    <div ng-repeat="user in users" index="{{$index}}" class="info" id="{{user.id}}" hasInfo="{{user.loadedInfo}}">
                        <div class="imageWrapper">
                            <notice-image isrc="user.avatar" save-to-local="true" default-src="theme/images/account_default_avatar.png"></notice-image>
                        </div>                        
                        <div class="name" ng-bind="user.displayName"></div>
                    </div>
                 </div>`,
        scope:{
            users:"="
        },
        restrict: "E",
        replace: true,
        link:function($scope,element){

            $scope.check = function(){
                var parentHeight = element[0].clientHeight;
                var infoNodes = element.find('.info');
                infoNodes.each(function(){
                    var top = $(this).position().top;
                    if(top > 0 && top < parentHeight){
                        $(this).css('visibility','visible');
                        var index = parseInt($(this).attr('index'));
                        if(!$scope.users[index].isLoadingInfo && !$scope.users[index].loadedInfo){
                            $scope.loadUserInfo(index);
                        }
                    }else{
                        $(this).css('visibility','hidden');
                    }
                });
            };

            $scope.loadUserInfo = function(index){
                var user = $scope.users[index];
                user.isLoadingInfo = true;
                notices.getBasicUserInfo(user.id,function(info){
                    utils.applyScope($scope,function(){
                        delete user.isLoadingInfo;
                        user.loadedInfo = true;
                        user.avatar = info.avatar;
                        user.displayName = info.displayName;
                    })
                });
            };

            element.on('scroll',function(){
                utils.applyScope($scope,function(){
                    $scope.check();
                });
            });

            $scope.$watch('users',function(newV){
                if(newV && newV.length > 0){
                    setTimeout(function(){
                        $scope.check()
                    });
                }
            });
        }
    }
}]);